FUNCTION spgridspline,sparray,lamarray

; 30 Jan 04 created
;
; regrids a spectral data array using the IDL routine cspline
; performs regridding order-by-order
; this early version assumes that order numbers in sparray and 
;   lamarray are the same
;
; INPUT - sparray  - spectral data array to be regridded
;         lamarray - spectral data array with new wavelength grid
;                    if this array has a col 3, this is assumed to be order
;                    otherwise, col 1 is assumed to be the order column
; OUTPUT - returns a new spectra data array with fluxes and errors
;          regridded

sz=size(lamarray)
nlamcol=sz[1]
if (nlamcol ge 4) then olcol=3 else olcol=1
oscol=3

; check min and max order for both arrays
; will process only those orders in common

minoorder=min(sparray[oscol,*])
maxoorder=max(sparray[oscol,*])
minnorder=min(lamarray[olcol,*])
maxnorder=max(lamarray[olcol,*])

minorder=max([minoorder,minnorder])
maxorder=min([maxoorder,maxnorder])

passflag=0
for o=minorder,maxorder do begin
  old_idx=where(sparray[oscol,*] eq o)
  new_idx=where(lamarray[olcol,*] eq o)

  if (max(old_idx) gt -1) and max(new_idx gt -1) then begin
    old_lam =reform(sparray[0,old_idx])
    old_flux=reform(sparray[1,old_idx])
    old_err =reform(sparray[2,old_idx])
    new_lam =reform(lamarray[0,new_idx]) 

    if (max(old_lam) gt 0.0 and max(new_lam) gt 0.0) then begin
      new_flux=cspline(old_lam,old_flux,new_lam)
      new_err =cspline(old_lam,old_err ,new_lam)

      ordarr=fltarr(4,n_elements(new_idx))
      ordarr[0,*]=new_lam
      ordarr[1,*]=new_flux
      ordarr[2,*]=new_err
      ordarr[3,*]=o

      if (passflag eq 0) then begin
        passflag=1
        outarr=ordarr
      endif else outarr=[[outarr],[ordarr]]

    endif 
  endif
endfor

return,outarr
END
