FUNCTION sptrim,sp,l0,l1

;  8 Dec 04 modified to be generic
; 28 Dec 03 created
;
; trims bad data from ends of orders
;
; INPUT
;   sp - spectral data array
;   la - vector of starting wavelength for each order
;   lb - vector of ending wavelength for each order
; OUTPUT - returns trimmed spectra data array
;
; assumed that columns are wavelength, flux, error, order

lcol=0
fcol=1
ocol=3

; iterate through orders and trim them
; load into out_array as we go

lam  =reform(sp[lcol,*])
order=reform(sp[ocol,*])
m0=min(order) & m1=max(order)
i=0
for m=m0,m1 do begin
  o_idx=where(m eq order)
  if (max(o_idx) gt -1) then begin
    seg_array=sp[*,o_idx]

    olam=lam[o_idx]
    cut_array=seg_array[*,where( (olam ge l0[i]) and (olam le l1[i]) )]
    if (m eq m0) then out_array=cut_array $
    else              out_array=[[out_array],[cut_array]]
    i=i+1
  endif
endfor

return,out_array

END
