PRO spplot,in_array,xtitle=xtitle,ytitle=ytitle,xrange=xrange,over=over,order=order,rj=rj,_extra=e

; 25 Jun 04 repaired major xrange bug
; 18 May 04 added keyword rj, plots Rayleigh-Jeans tail in lam^2*F_nu units
;  1 Feb 04 added keyword order, to plot one order
; 28 Dec 03 repaired minor bug with xrange for unsegmented plots
; 20 Dec 03 clearing up some bugs
; 15 Dec 03 modified to plot spectral segments separately
; 28 Nov 03 modified to add overplot capability
; 10 Nov 03 created
;
; plots the second column of data_array as a f'n of the first
; passes additional keywords on to plot
; sets default titles for x and y axis

; check keywords

if (keyword_set(over) eq 0) then overflag=0 else overflag=1
if (keyword_set(xrange) eq 0) then xranflag=0 else xranflag=1
if (keyword_set(rj) eq 0) then rjflag=0 else rjflag=1
if (keyword_set(order) eq 0) then data_array=in_array else begin
  index=where(in_array[3,*] eq order)
  if (max(index) gt -1) then data_array=in_array[*,index] else begin
    print,'Error in spplot.  No data of order ',order
    stop
  endelse
endelse 
if (keyword_set(xtitle) eq 0) then xtt='!7k!5 (!7l!5m)' else xtt=xtitle
if (keyword_set(ytitle) eq 0) then begin
  if (rjflag eq 0) then ytt='!5F!7!dm!5!n (Jy)' $
  else ytt='!7k!5!u2!nF!7!dm!5!n (Jy !7l!5m!u2!n)'
endif else ytt=ytitle

; check size of array

sz=size(data_array)
ncol=sz[1]
nlen=sz[2]
segcol=3 ; assuming that col 3 = order/segment column

; load wavelength and flux

l=reform(data_array[0,*])
f=reform(data_array[1,*])

if (rjflag eq 1) then f=f*l*l

; find min and max wavelength

xmin=min(l)
xmax=max(l)
if (xranflag eq 0) then xrange=[xmin,xmax]

; check to see if spectrum has segments
; assume segment information to be in column 3 (for now)
; if only two columns then set minseg=maxseg=0

if (ncol gt segcol) then begin
  minseg=min(data_array[segcol,*])
  maxseg=max(data_array[segcol,*])
endif else begin
  minseg=0
  maxseg=0
endelse

if (minseg lt maxseg) then begin ; we have segmented spectral data

; find segment with maximum flux (unless overplotting)
; if xranflag set, need to limit search to those segmenets with data in range

  if (overflag eq 0) then begin

    count=0
    for n=minseg,maxseg do begin
      segidx=where(data_array[segcol,*] eq n)
      if (max(segidx) gt -1) then begin
        if (min(l[segidx]) le max(xrange) and max(l[segidx]) ge min(xrange)) $
          then begin
          if (count eq 0) then begin
            maxfluxseg=n
            maxflux=max(f[where(data_array[segcol,*] eq n)])
          endif
          maxtest=max(f[segidx])
          if (maxtest gt maxflux) then begin
            maxflux=maxtest
            maxfluxseg=n
          endif
          count=count+1
        endif
      endif
    endfor

; plot segment with maximum flux (unless overplotting)

    segidx=where(data_array[segcol,*] eq maxfluxseg)
    l=reform(data_array[0,segidx])
    f=reform(data_array[1,segidx])
    if (rjflag eq 1) then f=f*l*l
    if (xranflag eq 1) then plot,l,f,xtit=xtt,ytit=ytt,xran=xrange,_extra=e $
    else plot,l,f,xtit=xtt,ytit=ytt,xran=[xmin,xmax],_extra=e

  endif

; now overplot all segments
  
  for n=minseg,maxseg do begin
    segidx=where(data_array[segcol,*] eq n)
    if (max(segidx) gt -1) then begin
      l=reform(data_array[0,segidx])
      f=reform(data_array[1,segidx])
      if (rjflag eq 1) then f=f*l*l
      oplot,l,f,_extra=e
    endif
  endfor
  
endif else begin                 ; spectrum is unsegmented
  if (overflag eq 0) then begin
    if (xranflag eq 1) then plot,l,f,xtit=xtt,ytit=ytt,xran=xrange,_extra=e $
    else plot,l,f,xtit=xtt,ytit=ytt,_extra=e
  endif else begin
    oplot,l,f,_extra=e
  endelse

endelse

end
