FUNCTION sppair,spa,spb,SIGMA=sigma,WIDTH=width

; 21 Mar 04 either reject or use data, do not use continuum, return uncertainty
;  8 Mar 04 created
;
; given two spectral data arrays, combine them and eliminate spikes
; algorithm:
;   generate continuum spectra for each input spectrum
;   generate difference spectra for each = abs(continuum-spectrum)
;   generate pass spectrum:
;   (1) at each wavelength, choose min of the two diff spectra
;   (2) replace small pass values by raising to median or mean of pass array
;   generate a weight array by comparing differences to pass array
;       w=0 if diff > pass*sigma, otherwise w=1
;       if both weights=0 for a given wavelength element, reset to 1
;   combine spectra by averaging
;   compute uncertainty as though all data were used
; INPUT
;   spa,spb - spectral data arrays
;   SIGMA   - number of times pass before data replaced
;   WIDTH   - size of box for median
; OUTPUT
;   spike-corrected and averaged spectrum

; check keywords

if (keyword_set(sigma) eq 0) then sigma=15.0
if (keyword_set(width) eq 0) then width=5

; check that spectral arrays are the same size
; and initialize new spectral data array newspec

len=n_elements(spa[1,*])
if (len ne n_elements(spb[1,*])) then begin
  print,"Error.  Spectral sizes do not match."
  stop
endif
newspec=spa

; load wavelength, flux, continuum, diff spectra, pass spectrum
; continuum spectra are media of flux spectra

lam=reform(spa[0,*])
fluxa=reform(spa[1,*])
fluxb=reform(spb[1,*])

cona=median(fluxa,width)
conb=median(fluxb,width)

diffa=abs(fluxa-cona)
diffb=abs(fluxb-conb)
pass=diffa-diffa ; set to zero

for i=0,len-1 do pass[i]=min([diffa[i],diffb[i]]) ; minimum difference

; raise low values of pass to smaller of median or mean of pass array 

minpass=min([median(pass),mean(pass)])
bad_idx=where(pass lt minpass)
print,minpass,min(pass)
if (max(bad_idx) gt -1) then pass[bad_idx] = minpass

; set weight arrays wt_a and wt_b
; default is 1.0
; if both wt_a and wt_b for a given wavelength element=0, reset to 1
;   this shouldn't happen, but it would indicate the pixel is hopeless

wt_a=fltarr(len)+1.0
wt_b=wt_a

bad_idx=where(diffa gt sigma*pass)
if (max(bad_idx) gt -1) then wt_a[bad_idx]=0.0
bad_idx=where(diffb gt sigma*pass)
if (max(bad_idx) gt -1) then wt_b[bad_idx]=0.0
bad_idx=where(wt_a eq 0.0 and wt_b eq 0.0)
if (max(bad_idx) gt -1) then begin
  print,'There are ',n_elements(bad_idx),' hopeless pixels'
  wt_a[bad_idx] =1.0
  wt_b[bad_idx] =1.0
endif

; combine spectra by weighted averaging
; generate new uncertainties

newspec[1,*]=(fluxa*wt_a+fluxb*wt_b)/(wt_a+wt_b)
newspec[2,*]=stddev(fluxa

newspec[1,*]=0.5*(fluxa+fluxb)
return,newspec

END
