function spdivide,l1,f1,e1,f2,e2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;	spdivide.pro	MJR	13 Nov 03
;
;  Divides two spectrums, returns f1/f2
;
;  l1 = wavelength grid of BOTH spectrums
;  f1 = dividend flux
;  e1 = uncertainty in f1
;  f2 = divisor flux
;  e2 = uncertainty in f2
;
;  Error propagation from Bevington (1969) p62
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


len = n_elements(l1)
num = f1
den = f2

; replace zeroes with a small number to avoid dividing by zero
index = where(f2 eq 0)
den(index) = .000001


outarray = fltarr(3,len)
outarray(0,*) = l1
outarray(1,*) = num/den
outarray(2,*) = sqrt(  outarray(1,*)^2*((e1/num)^2 + (e2/den)^2)  )

return,outarray
end
